/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import Entity.Collectable;
import Entity.Enemies.BlackHole;
import Entity.Enemies.Comet;
import Entity.Enemies.Invader;
import Entity.Enemies.InvaderBullet;
import Entity.Enemy;
import Entity.Explosion;
import Entity.Life;
import Entity.Player;
import Entity.PlayerSave;
import Entity.PowerUp;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class PlayState
extends GameState {
    private long startTime;
    private long tempStartTime;
    private long tempElapsed;
    private long cometSpawnDelay = 2000L;
    private int miny = 30;
    private int maxy = 370;
    private double mindx = -2.0;
    private double maxdx;
    private int numOfInvaders = 0;
    private int maxInvaders = 3;
    private int numOfBlackHoles = 0;
    private int maxBlackHoles = 2;
    private Player player;
    private ArrayList<Enemy> enemies;
    private ArrayList<Explosion> explosions;
    private ArrayList<Collectable> collectables;
    private int powerUpDropRate;
    private BufferedImage blueIcon;
    private BufferedImage greenIcon;
    private BufferedImage redIcon;
    private Background bg2;
    private Background bg3;
    private boolean paused;
    private Font font;
    private Font pausedFont;

    public PlayState(GameStateManager gsm) {
        this.gsm = gsm;
        this.font = new Font("Arial", 0, 22);
        this.pausedFont = new Font("Arial", 0, 36);
        this.blueIcon = Content.BluePowerUp;
        this.greenIcon = Content.GreenPowerUp;
        this.redIcon = Content.RedPowerUp;
        this.paused = false;
        this.bg2 = new Background("/Backgrounds/starMG.png", 1.0);
        this.bg2.setVector(-2.0, 0.0);
        this.bg3 = new Background("/Backgrounds/starFG.png", 1.0);
        this.bg3.setVector(-4.0, 0.0);
        AudioPlayer.load("/Music/Game_Song.mp3", "gameSong");
        AudioPlayer.load("/SFX/Pause.mp3", "pause");
        AudioPlayer.load("/SFX/Unpause.mp3", "unpause");
    }

    @Override
    public void init() {
        AudioPlayer.loop("gameSong", 0.0);
        this.checkDifficulty();
        this.startTime = System.nanoTime();
        PlayerSave.init();
        this.player = new Player();
        this.player.setPosition(100.0, 100.0);
        this.enemies = new ArrayList();
        this.explosions = new ArrayList();
        this.collectables = new ArrayList();
    }

    @Override
    public void update() {
        this.handleInput();
        if (!this.paused) {
            Enemy e;
            this.bg2.update();
            this.bg3.update();
            int randomInty = (int)(Math.random() * (double)(this.maxy - this.miny) + (double)this.miny);
            double randomDoubledx = Math.random() * (this.maxdx - this.mindx) + this.mindx;
            int randomSpawn = (int)(Math.random() * 99.0 + 1.0);
            long elapsedComet = (System.nanoTime() - this.startTime) / 1000000L - this.tempElapsed;
            if (elapsedComet > this.cometSpawnDelay) {
                Comet c;
                this.tempElapsed = 0L;
                if (randomSpawn >= 20) {
                    c = new Comet();
                    this.enemies.add(c);
                    c.setPosition(850.0, randomInty);
                    c.setVector(randomDoubledx, 0.0);
                } else if (randomSpawn >= 5 && randomSpawn < 20 && this.numOfInvaders != this.maxInvaders) {
                    Invader i = new Invader();
                    this.enemies.add(i);
                    i.setPosition(850.0, randomInty);
                    ++this.numOfInvaders;
                } else if (randomSpawn >= 1 && randomSpawn < 5 && this.numOfBlackHoles != this.maxBlackHoles) {
                    BlackHole blackHole = new BlackHole();
                    blackHole.setPosition(900.0, randomInty);
                    this.enemies.add(blackHole);
                    ++this.numOfBlackHoles;
                } else {
                    c = new Comet();
                    this.enemies.add(c);
                    c.setPosition(850.0, randomInty);
                    c.setVector(randomDoubledx, 0.0);
                }
                this.startTime = System.nanoTime();
                this.cometSpawnDelay -= 5L;
                if (this.cometSpawnDelay < 400L) {
                    this.cometSpawnDelay = 400L;
                }
            }
            this.player.update();
            this.player.checkAttack(this.enemies, this.collectables);
            int i = 0;
            while (i < this.enemies.size()) {
                e = this.enemies.get(i);
                e.update();
                if (e.shouldRemove()) {
                    int randomInt;
                    PlayerSave.addScore(e.getScore());
                    this.enemies.remove(i);
                    --i;
                    if (e.getID() == 1) {
                        --this.numOfInvaders;
                        Explosion ex = new Explosion(1);
                        ex.setPosition(e.getx(), e.gety());
                        this.explosions.add(ex);
                        AudioPlayer.play("boom", 1.0);
                    }
                    if (e.getID() == 3) {
                        --this.numOfBlackHoles;
                    }
                    if ((randomInt = (int)(Math.random() * 99.0 + 1.0)) <= this.powerUpDropRate) {
                        PowerUp pu = new PowerUp();
                        pu.setPosition(e.getx(), e.gety());
                        this.collectables.add(pu);
                    } else if (randomInt >= 98) {
                        Life l = new Life();
                        l.setPosition(e.getx() + l.getWidth() / 2, e.gety() + l.getHeight() / 2);
                        this.collectables.add(l);
                    }
                }
                if (e.shouldShoot()) {
                    e.setShoot(false);
                    InvaderBullet ib = new InvaderBullet();
                    this.enemies.add(ib);
                    ib.setPosition(e.getx(), e.gety());
                }
                ++i;
            }
            i = 0;
            while (i < this.explosions.size()) {
                this.explosions.get(i).update();
                if (this.explosions.get(i).shouldRemove()) {
                    this.explosions.remove(i);
                    --i;
                }
                ++i;
            }
            i = 0;
            while (i < this.collectables.size()) {
                this.collectables.get(i).update();
                if (this.collectables.get(i).shouldRemove()) {
                    this.collectables.remove(i);
                    --i;
                }
                ++i;
            }
            i = 0;
            while (i < this.enemies.size()) {
                e = this.enemies.get(i);
                int j = i + 1;
                while (j < this.enemies.size()) {
                    Enemy e2 = this.enemies.get(j);
                    if (e.intersects(e2)) {
                        if (e.getID() == 3) {
                            e2.hit(99, e2.getID());
                        }
                        if (e2.getID() == 3) {
                            e.hit(99, e.getID());
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (PlayerSave.getHealth() == 0) {
                AudioPlayer.stop("gameSong");
                if (this.player.getDead()) {
                    this.gsm.setState(2);
                    PlayerSave.setHighScores();
                }
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.bg2.draw(g);
        this.bg3.draw(g);
        int i = 0;
        while (i < this.collectables.size()) {
            this.collectables.get(i).draw(g);
            ++i;
        }
        this.player.draw(g);
        i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).draw(g);
            ++i;
        }
        g.setFont(this.font);
        g.setColor(Color.white);
        if (PlayerSave.getDifficulty() == 0) {
            g.drawString("Difficulty : Easy", 640, 390);
        }
        if (PlayerSave.getDifficulty() == 1) {
            g.drawString("Difficulty : Normal", 620, 390);
        }
        if (PlayerSave.getDifficulty() == 2) {
            g.drawString("Difficulty : Hard", 640, 390);
        }
        g.drawString("Weapon : ", 5, 390);
        g.drawString("Lives : " + PlayerSave.getHealth() + "     Score : " + PlayerSave.getScore(), 5, 21);
        g.drawString("Ammo :       ", 250, 21);
        g.drawString("" + PlayerSave.getAmmo(1), 390, 21);
        g.drawString("" + PlayerSave.getAmmo(2), 465, 21);
        g.drawString("" + PlayerSave.getAmmo(3) / 10, 535, 21);
        g.drawImage((Image)this.redIcon, 368, 3, null);
        g.drawImage((Image)this.greenIcon, 445, 3, null);
        g.drawImage((Image)this.blueIcon, 513, 3, null);
        PlayerSave.setText();
        g.setColor(PlayerSave.getColor());
        g.drawString(PlayerSave.getWeapon(), 105, 390);
        if (this.paused) {
            g.drawImage((Image)Content.PauseBG, 0, 0, null);
            g.setColor(Color.white);
            g.setFont(this.pausedFont);
            this.gsm.drawCenteredString("PAUSED", 800, 400, g);
            g.setFont(this.font);
            this.gsm.drawCenteredString("Press Escape for Main Menu", 800, 600, g);
        }
    }

    @Override
    public void handleInput() {
        if (!this.paused) {
            if (Keys.isKeyPressed(Keys.P) && PlayerSave.getHealth() != 0) {
                this.paused = true;
                this.tempStartTime = System.nanoTime();
                Background.stop = true;
                AudioPlayer.play("pause", 1.0);
                AudioPlayer.stop("gameSong");
            }
            if (Keys.isKeyPressed(Keys.Q)) {
                PlayerSave.setPowerUpState(0);
            }
            if (Keys.isKeyPressed(Keys.W)) {
                PlayerSave.setPowerUpState(1);
            }
            if (Keys.isKeyPressed(Keys.E)) {
                PlayerSave.setPowerUpState(2);
            }
            if (Keys.isKeyPressed(Keys.R)) {
                PlayerSave.setPowerUpState(3);
            }
            this.player.setUp(Keys.keyState[Keys.UP]);
            this.player.setLeft(Keys.keyState[Keys.LEFT]);
            this.player.setDown(Keys.keyState[Keys.DOWN]);
            this.player.setRight(Keys.keyState[Keys.RIGHT]);
            this.player.setShooting(Keys.keyState[Keys.SPACE]);
        } else {
            if (Keys.isKeyPressed(Keys.ESCAPE)) {
                AudioPlayer.stop("gameSong");
                AudioPlayer.loop("introMusic", 0.0);
                Background.stop = false;
                this.gsm.setState(0);
            }
            if (Keys.isKeyPressed(Keys.P)) {
                this.paused = false;
                AudioPlayer.play("unpause", 1.0);
                this.tempElapsed = (System.nanoTime() - this.tempStartTime) / 1000000L;
                Background.stop = false;
                AudioPlayer.resume("gameSong", 0.0);
            }
        }
    }

    private void checkDifficulty() {
        if (PlayerSave.getDifficulty() == 0) {
            this.maxdx = -6.0;
            this.cometSpawnDelay = 2000L;
            this.powerUpDropRate = 12;
            this.maxInvaders = 2;
            PlayerSave.tripleBulletAmmoAdd = 30;
            PlayerSave.missilesAmmoAdd = 20;
            PlayerSave.beamAmmoAdd = 300;
        } else if (PlayerSave.getDifficulty() == 1) {
            this.maxdx = -8.0;
            this.cometSpawnDelay = 1500L;
            this.powerUpDropRate = 8;
            this.maxInvaders = 3;
            PlayerSave.tripleBulletAmmoAdd = 20;
            PlayerSave.missilesAmmoAdd = 10;
            PlayerSave.beamAmmoAdd = 200;
        } else if (PlayerSave.getDifficulty() == 2) {
            this.maxdx = -10.0;
            this.cometSpawnDelay = 1000L;
            this.powerUpDropRate = 4;
            this.maxInvaders = 5;
            PlayerSave.tripleBulletAmmoAdd = 10;
            PlayerSave.missilesAmmoAdd = 5;
            PlayerSave.beamAmmoAdd = 100;
        }
    }
}

